events.listen('recipes', function (event) {

  var unifyMetal = function (name, ingotItem, dustItem, blockItem, nuggetItem) {
    event.replaceOutput('#forge:ingots/' + name, ingotItem)
    event.replaceOutput('#forge:dusts/' + name, dustItem)
    event.replaceOutput('#forge:nuggets/' + name, nuggetItem)
    event.replaceOutput('#forge:storage_blocks/' + name, blockItem)
    event.remove({ output: '#forge:ingots/' + name, type: 'minecraft:smelting' })
    event.remove({ output: '#forge:ingots/' + name, type: 'minecraft:blasting' })
    event.recipes.minecraft.smelting(ingotItem, '#forge:dusts/' + name)
    event.recipes.minecraft.blasting(ingotItem, '#forge:dusts/' + name)
    if (name !== 'steel' && name !== 'bronze') {
      event.recipes.minecraft.smelting(ingotItem, '#forge:ores/' + name)
      event.recipes.minecraft.blasting(ingotItem, '#forge:ores/' + name)
    }
  }

  unifyMetal('iron', 'minecraft:iron_ingot', 'mekanism:dust_iron', 'minecraft:iron_block', 'minecraft:iron_nugget')
  unifyMetal('gold', 'minecraft:gold_ingot', 'mekanism:dust_gold', 'minecraft:gold_block', 'minecraft:gold_nugget')
  unifyMetal('copper', 'mekanism:ingot_copper', 'mekanism:dust_copper', 'mekanism:block_copper', 'mekanism:nugget_copper')
  unifyMetal('tin', 'mekanism:ingot_tin', 'mekanism:dust_tin', 'mekanism:block_tin', 'mekanism:nugget_tin')
  unifyMetal('steel', 'mekanism:ingot_steel', 'mekanism:dust_steel', 'mekanism:block_steel', 'mekanism:nugget_steel')
  unifyMetal('uranium', 'mekanism:ingot_uranium', 'mekanism:dust_uranium', 'mekanism:block_uranium', 'mekanism:nugget_uranium')
  unifyMetal('lead', 'mekanism:ingot_lead', 'mekanism:dust_lead', 'mekanism:block_lead', 'mekanism:nugget_lead')
  unifyMetal('bronze', 'mekanism:ingot_bronze', 'mekanism:dust_bronze', 'mekanism:block_bronze', 'mekanism:nugget_bronze')
  unifyMetal('silver', 'silents_mechanisms:silver_ingot', 'silents_mechanisms:silver_dust', 'silents_mechanisms:silver_block', 'silents_mechanisms:silver_nugget')
  unifyMetal('aluminum', 'silents_mechanisms:aluminum_ingot', 'silents_mechanisms:aluminum_dust', 'silents_mechanisms:aluminum_block', 'silents_mechanisms:aluminum_nugget')

})